﻿using System.ComponentModel.DataAnnotations;

namespace FAQ.Entities
{
    public class Question
    {
        /// <summary>
        /// id de la question
        /// exemple: 1
        /// </summary>
        public int IdQuestion { get; set; }

        /// <summary>
        /// Contenu de la question
        /// exemple: quoi?
        /// </summary>
        [Required]
        public string Titre { get; set; }

        /// <summary>
        /// Réponse à la question
        /// </summary>
        [Required]
        public string Reponse { get; set; }

        /// <summary>
        /// Date de création de la question
        /// </summary>
        public string Date_Creation { get; set; }

        /// <summary>
        /// Date de la dernière modification de la question
        /// </summary>
        public string Date_Modif { get; set; }

        /// <summary>
        /// Catégorie de la question
        /// </summary>
        [Required]
        public string Categorie { get; set; }

        /// <summary>
        /// Constructeur de la classe Question
        /// </summary>
        /// <param name="id">id de la question</param>
        /// <param name="titre">Contenu de la question</param>
        /// <param name="reponse">Réponse à la question</param>
        /// <param name="dateCreation">Date de création de la question</param>
        /// <param name="dateModif">Date de la dernière modification de la question</param>
        /// <param name="categorie">Catégorie de la question</param>
        public Question(int id, string titre, string reponse, string dateCreation, string dateModif, string categorie)
        {
            IdQuestion = id;
            Titre = titre;
            Reponse = reponse;
            Date_Creation = dateCreation;
            Date_Modif = dateModif;
            Categorie = categorie;
        }

    }
}
